#include "ScreenQuadPS_Rm.hlsl"

float domainMax()
{
    return (LedCubeSide + LedCubeSideMinusOne) * ( 1 - smoothstep(0, 1, SequenceRatio)); 
}

float4 main( PS_INPUT input) : SV_Target
{
      class StartDomain : LedDomain 
    { 
       bool IsOutside(in float3 p)
        {
            return any(p > 1. + domainMax()) || any(p < 0 );
        }
    } startDomain;

    class Emtpyscene : IntensityProvider 
    { 
        float IntensityAt(float3 p) 
        { 
            return SequenceRatio*2-1;
          
        }
    } emtpyscene;

    class Cam : CamAnimator
    {
         float2x3 GetRays()
         {
            // UV --> input.Text.xy e [0 1]
            /*
            o---------X
            |
            |
            |
            |
            Y
            */

                      // Pixel position
                      // Pixel position
            float2 pixel = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
                // pixel.xy e [-1 1], same orientation
                //Let's move in view space, right handed (to fiz cross product errors
            //float3 rayOrigin    = float3(LedCubeSide,HalfLedCubeSide, 3*LedCubeSide);

            float smooth = smoothstep(0, 0.5, SequenceRatio);
            float3 rayOrigin = float3(HalfLedCubeSide,HalfLedCubeSide, 2*LedCubeSide);
            rayOrigin += (1 - smooth)* float3(HalfLedCubeSide,0., LedCubeSide);
            
            float3 rayDirection = normalize(float3(pixel.x * ScreenRatio, -pixel.y, -2));
            float t =  0.18 * (1 - smooth);
            rayDirection =  rotateX(rayDirection, t);


            float2x3 array = {rayOrigin, rayDirection};

            return array;
         }
    } cam;
    


   
   return rayMarcher(cam, emtpyscene, startDomain);
}